<?php

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Confidence;

use FernleafSystems\Wordpress\Services\Services;

/**
 * Class Retrieve
 * @package FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Confidence
 */
class Retrieve extends Base {

	const RESPONSE_DATA_KEY = 'confidence';

	/**
	 * @return string
	 */
	protected function getApiUrl() {
		$aData = array_filter( array_merge(
			[
				'type' => false,
				'file' => false,
				'hash' => false,
				'algo' => false,
			],
			$this->getRequestVO()->getRawDataAsArray()
		) );
		return sprintf( '%s/%s', parent::getApiUrl(), implode( '/', $aData ) );
	}

	/**
	 * @param string $sFullPath
	 * @param string $sAlgo
	 * @return array
	 */
	public function retrieveForFile( $sFullPath, $sAlgo = 'sha1' ) {
		/** @var RequestVO $oReq */
		$oReq = $this->getRequestVO();
		$oReq->type = 'file';
		$oReq->file = basename( $sFullPath );
		$oReq->hash = hash( $sAlgo, Services::DataManipulation()->convertLineEndingsDosToLinux( $sFullPath ) );
		$oReq->algo = $sAlgo;
		return $this->query();
	}

	/**
	 * @param string $sFullPath
	 * @param string $sLine
	 * @param string $sAlgo
	 * @return array
	 */
	public function retrieveForFileLine( $sFullPath, $sLine, $sAlgo = 'sha1' ) {
		/** @var RequestVO $oReq */
		$oReq = $this->getRequestVO();
		$oReq->type = 'line';
		$oReq->file = basename( $sFullPath );
		$oReq->hash = hash( $sAlgo, trim( $sLine ) );
		$oReq->algo = $sAlgo;
		return $this->query();
	}
}