<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malai;

use FernleafSystems\Wordpress\Services\Utilities\Constants\Regex;

class QueryMalwareStatusMulti extends Base {

	public const API_ENDPOINT = 'statuses';
	public const REQUEST_TYPE = 'POST';

	public function retrieve( array $hashesSha256 ) :array {
		$statuses = [];
		$hashesSha256 = \array_filter( $hashesSha256, function ( $hash ) {
			return \is_string( $hash ) && \preg_match( sprintf( '#^%s$#', Regex::HASH_SHA256 ), $hash );
		} );
		if ( !empty( $hashesSha256 ) ) {
			$this->getRequestVO()->hashes_sha256 = $hashesSha256;
			$result = $this->query();
			$statuses = ( \is_array( $result ) && !empty( $result[ 'statuses' ] ) ) ? $result[ 'statuses' ] : [];
		}
		return $statuses;
	}
}