<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Modules\HackGuard\DB\Malware\Ops;

trait Common {

	public function filterByCodeType( string $codeType ) {
		return $this->addWhereEquals( 'code_type', $codeType );
	}

	public function filterByFilePath( string $filePath ) {
		return $this->addWhereEquals( 'file_path', $filePath );
	}

	public function filterBySHA256( string $binaryHash ) {
		return $this->addWhereEquals( 'hash_sha256', $binaryHash );
	}

	public function filterByUnreported() {
		return $this->addWhereEquals( 'reported_at', 0 );
	}
}